import csv
import pytz
import datetime

import pandas as pd
from dateutil import parser


class App:

    @staticmethod
    def main():
        bot = App.read_bot()

        print(bot)

        dataset = {}
        for i, row in bot.iterrows():
            dataset[row['owner'], row['repo'], row['bot']] = App.create_empty_dataset(Utils.string_to_date(row['first_bot_comment']))

        data_filename = "data.csv"
        with open(data_filename, 'w') as csvfile:
            data_writer = csv.writer(csvfile, delimiter=',', quotechar='"', quoting=csv.QUOTE_MINIMAL)
            data_writer.writerow(['owner', 'repo', 'bot', 'month_start', 'month_end', 'time', 'intervention', 'time_after_intervention'])

            for key in dataset.keys():
                for entry in dataset[key]:

                    data_writer.writerow([key[0], key[1], key[2], entry['month_start'].strftime('%Y-%m-%d'), entry['month_end'].strftime('%Y-%m-%d'), entry['time'], entry['intervention'], entry['time_after_intervention']])

    @staticmethod
    def read_bot():
        filename = "data/sample_codereview.csv"
        return Utils.read_csv(filename, ',')

    @staticmethod
    def create_empty_dataset(first_bot_adoption_date, months=24, period=15):
        empty_dataset = []
        delta = datetime.timedelta(days=period)

        after_current = first_bot_adoption_date + datetime.timedelta(days=15)
        before_current = first_bot_adoption_date - datetime.timedelta(days=15)

        for i in range(0, months):
            empty_dataset.append(App.create_empty_entry(after_current, after_current + delta - datetime.timedelta(days=1), 24+i+1, True, i+1))
            empty_dataset.insert(0, App.create_empty_entry(before_current - delta + datetime.timedelta(days=1), before_current, 24-i, False, 0))

            after_current = after_current + delta
            before_current = before_current - delta

        return empty_dataset

    @staticmethod
    def create_empty_entry(month_start, month_end, time, intervention, time_after_intervention):
        return {'month_start': month_start.replace(tzinfo=pytz.UTC), 'month_end': month_end.replace(tzinfo=pytz.UTC), 'time': time, 'intervention': intervention, 'time_after_intervention': time_after_intervention}


class Utils:

    def string_to_date(string):
        return parser.parse(string)

    def read_csv(filename, sep):
        return pd.read_csv(filename, sep)


if __name__ == "__main__":
    App.main()